/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.tinkersconstruct;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.tinkersconstruct.TinkersRecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;

public class CastingTableRecipeJS
extends TinkersRecipeJS {
    public void create(ListJS args) {
        this.outputItems.add(this.parseResultItem(args.get(0)));
        this.inputItems.add(IngredientJS.of((Object)"#tconstruct:casts/multi_use/ingot"));
        this.json.add("fluid", (JsonElement)this.createFluid(args.get(1).toString(), args.size() >= 3 ? ((Number)args.get(2)).intValue() : 144));
        this.json.addProperty("cooling_time", (Number)60);
    }

    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("result")));
        if (this.json.has("cast")) {
            this.inputItems.add(this.parseIngredientItem(this.json.get("cast")));
        }
    }

    public CastingTableRecipeJS cast(IngredientJS in) {
        if (this.inputItems.isEmpty()) {
            this.inputItems.add(in);
        } else {
            this.inputItems.set(0, in);
        }
        this.serializeInputs = true;
        this.save();
        return this;
    }

    public CastingTableRecipeJS cast(IngredientJS in, boolean consume) {
        return this.cast(in).consumeCast(consume);
    }

    public CastingTableRecipeJS noCast() {
        this.inputItems.remove(0);
        this.serializeInputs = true;
        this.save();
        return this;
    }

    public CastingTableRecipeJS multiUseCast(String cast) {
        return this.cast(IngredientJS.of((Object)("#tconstruct:casts/multi_use/" + cast)));
    }

    public CastingTableRecipeJS singleUseCast(String cast) {
        return this.cast(IngredientJS.of((Object)("#tconstruct:casts/single_use/" + cast))).consumeCast();
    }

    public CastingTableRecipeJS consumeCast(boolean consume) {
        this.json.addProperty("cast_consumed", Boolean.valueOf(consume));
        this.save();
        return this;
    }

    public CastingTableRecipeJS consumeCast() {
        return this.consumeCast(true);
    }

    public CastingTableRecipeJS switchSlots() {
        this.json.addProperty("switch_slots", Boolean.valueOf(true));
        this.save();
        return this;
    }

    public CastingTableRecipeJS coolingTime(int t) {
        this.json.addProperty("cooling_time", (Number)t);
        this.save();
        return this;
    }

    public CastingTableRecipeJS fluid(String id, int amount) {
        this.json.add("fluid", (JsonElement)this.createFluid(id, amount));
        this.save();
        return this;
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.addProperty("result", ((ItemStackJS)this.outputItems.get(0)).getId());
        }
        if (this.serializeInputs) {
            if (this.inputItems.isEmpty()) {
                this.json.remove("cast");
            } else {
                this.json.add("cast", ((IngredientJS)this.inputItems.get(0)).toJson());
            }
        }
    }
}

